/*############################################################################*/
/*#                                                                          #*/
/*#  Ambisonic C++ Library                                                   #*/
/*#  Copyright © 2017 Videolabs                                              #*/
/*#                                                                          #*/
/*#  Filename:      AmbisonicProcessor.cpp                                   #*/
/*#  Version:       0.2                                                      #*/
/*#  Date:          19/05/2007                                               #*/
/*#  Author(s):     Peter Stitt, Bruce Wiggins                               #*/
/*#  Licence:       LGPL                                                     #*/
/*#                                                                          #*/
/*############################################################################*/

// Decoder coefficients for Ambisonics to stereo. Useful for conversion to 2-channels when not using headphone.
const float decoder_coefficient_stereo[][16] =
{
{0.5f, 0.5f / 3.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f},
{0.5f, -0.5f / 3.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f}
};

// First order decoder for 5.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_first_5_1[][4] = { {0.300520f, 0.135000f, 0.000000f, 0.120000f},
{0.300520f, -0.135000f, 0.000000f, 0.120000f},
{0.332340f, 0.138333f, 0.000000f, -0.110000f},
{0.332340f, -0.138333f, 0.000000f, -0.110000f},
{0.141421f, 0.000000f, 0.000000f, 0.053333f},
{0.500000f, 0.000000f, 0.000000f, 0.000000f} };

// Second order decoder for 5.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_second_5_1[][9] = { {0.286378f, 0.103333f, -0.000000f, 0.106667f, 0.028868f, 0.000000f, 0.000000f, 0.000000f, 0.019630f},
{0.286378f, -0.103333f, -0.000000f, 0.106667f, -0.028868f, 0.000000f, 0.000000f, -0.000000f, 0.019630f},
{0.449013f, 0.093333f, -0.000000f, -0.111667f, 0.018475f, -0.000000f, -0.000000f, 0.000000f, -0.018475f},
{0.449013f, -0.093333f, -0.000000f, -0.111667f, -0.018475f, -0.000000f, -0.000000f, 0.000000f, -0.018475f},
{0.060104f, 0.000000f, 0.000000f, 0.013333f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.010392f},
{0.500000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f} };

// Third order decoder for 5.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_third_5_1[][16] = { {0.219203f, 0.095000f, 0.000000f, 0.103333f, 0.042724f, 0.000000f, 0.000000f, 0.000000f, 0.001155f, 0.010842f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.004518f},
{0.219203f, -0.095000f, 0.000000f, 0.103333f, -0.042724f, 0.000000f, 0.000000f, 0.000000f, 0.001155f, -0.010842f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.004518f},
{0.417193f, 0.128333f, 0.000000f, -0.111667f, 0.004619f, 0.000000f, 0.000000f, 0.000000f, -0.005774f, -0.011746f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.004518f},
{0.417193f, -0.128333f, 0.000000f, -0.111667f, -0.004619f, 0.000000f, 0.000000f, 0.000000f, -0.005774f, 0.011746f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.004518f},
{0.095459f, 0.000000f, 0.000000f, 0.088333f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.049652f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.018974f},
{0.500000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f} };


// 7.1 Decoders
// First order decoder for 7.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_first_7_1[][4] = { {0.303082f, 0.095958f, 0.000000f, 0.114243f},
{0.303082f, -0.095958f, 0.000000f, 0.114243f},
{0.300098f, 0.124767f, 0.000000f, -0.017447f},
{0.300098f, -0.124767f, 0.000000f, -0.017447f},
{0.259458f, 0.053266f, 0.000000f, -0.117329f},
{0.259458f, -0.053266f, 0.000000f, -0.117329f},
{0.066262f, 0.000000f, 0.000000f, 0.031737f},
{0.500000f, 0.000000f, 0.000000f, 0.000000f} };

// Second order decoder for 7.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_second_7_1[][9] = { {0.268964f, 0.090325f, 0.000000f, 0.111024f, 0.044867f, 0.000000f, 0.000000f, 0.000000f, 0.015736f},
{0.268964f, -0.090325f, 0.000000f, 0.111024f, -0.044867f, -0.000000f, 0.000000f, 0.000000f, 0.015736f},
{0.229483f, 0.136694f, 0.000000f, -0.018120f, -0.020953f, 0.000000f, 0.000000f, 0.000000f, -0.049001f},
{0.229483f, -0.136694f, 0.000000f, -0.018120f, 0.020953f, -0.000000f, 0.000000f, 0.000000f, -0.049001f},
{0.216456f, 0.042012f, 0.000000f, -0.116220f, -0.038878f, 0.000000f, 0.000000f, 0.000000f, 0.032005f},
{0.216456f, -0.042012f, 0.000000f, -0.116220f, 0.038878f, -0.000000f, 0.000000f, 0.000000f, 0.032005f},
{0.058222f, 0.000000f, 0.000000f, 0.048933f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.025293f},
{0.500000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f} };

// Third order decoder for 7.1 loudspeaker array
// Do not activate psychoacoustic optimisation filters
const float decoder_coefficient_third_7_1[][16] = { {0.238475f, 0.085873f, 0.000000f, 0.114877f, 0.054573f, 0.000000f, 0.000000f, 0.000000f, 0.015163f, 0.006254f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.006185f},
{0.238475f, -0.085873f, 0.000000f, 0.114877f, -0.054573f, -0.000000f, 0.000000f, 0.000000f, 0.015163f, -0.006254f, -0.000000f, -0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.006185f},
{0.214882f, 0.124042f, 0.000000f, -0.017580f, -0.018064f, 0.000000f, 0.000000f, 0.000000f, -0.060255f, -0.011908f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.008159f},
{0.214882f, -0.124042f, 0.000000f, -0.017580f, 0.018064f, -0.000000f, 0.000000f, 0.000000f, -0.060255f, 0.011908f, -0.000000f, -0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.008159f},
{0.197904f, 0.043357f, 0.000000f, -0.115673f, -0.048364f, 0.000000f, 0.000000f, 0.000000f, 0.034129f, 0.017198f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.001868f},
{0.197904f, -0.043357f, 0.000000f, -0.115673f, 0.048364f, -0.000000f, 0.000000f, 0.000000f, 0.034129f, -0.017198f, -0.000000f, -0.000000f, 0.000000f, 0.000000f, 0.000000f, -0.001868f},
{0.077144f, 0.000000f, 0.000000f, 0.045620f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.030548f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.025329f},
{0.500000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f, 0.000000f} };
